<?php
define('_VALID', true);
require 'include/config.local.php';
require 'include/security.php';
require 'include/sessions.php';

disableRegisterGlobals();

define('XMOOV_GET_AUTHENTICATION', 'token');
if($_GET[XMOOV_GET_AUTHENTICATION] != 'K49sS9q0') {
   header('HTTP/1.0 401 Access Denied');
   exit;
}

define('XMOOV_PATH_ROOT', $config['BASE_DIR']. '/');
define('XMOOV_PATH_FILES', 'media/videos/flv/');
define('XMOOV_CONF_LIMIT_BANDWIDTH', FALSE);
define('XMOOV_CONF_ALLOW_FILE_CACHE', FALSE);
define('XMOOV_BW_PACKET_SIZE', 90);
define('XMOOV_BW_PACKET_INTERVAL', 0.3);
define('XMOOV_CONF_ALLOW_DYNAMIC_BANDWIDTH', TRUE);
define('XMOOV_GET_FILE', 'file');
define('XMOOV_GET_POSITION', 'start');
define('XMOOV_GET_BANDWIDTH', 'bw');
    
function getBandwidthLimit($part) {
    switch($part) {
        case 'interval' :
            switch($_GET[XMOOV_GET_BANDWIDTH])
            {
                case 'low' :
                    return 0.5;
                    break;
                case 'mid' :
                    return 0.5;
                    break;
                case 'high' :
                    return 0.2;
                    break;
                case 'off' :
                    return 0;
                    break;
                default :
                    return XMOOV_BW_PACKET_INTERVAL;
                    break;
            }
            break;
        case 'size' :
            switch($_GET[XMOOV_GET_BANDWIDTH])
            {
                case 'low' :
                    return 20;
                    break;
                case 'mid' :
                    return 40;
                    break;
                case 'high' :
                    return 90;
                    break;
                default :
                    return XMOOV_BW_PACKET_SIZE;
                    break;
            }
            break;
    }
}
    
if(isset($_GET[XMOOV_GET_FILE]) && isset($_GET[XMOOV_GET_POSITION])) {
    $seekPos = intval($_GET[XMOOV_GET_POSITION]);
    $fileName = htmlspecialchars($_GET[XMOOV_GET_FILE]);
    $file = XMOOV_PATH_ROOT . XMOOV_PATH_FILES . $fileName;
    $packet_interval = (XMOOV_CONF_ALLOW_DYNAMIC_BANDWIDTH && isset($_GET[XMOOV_GET_BANDWIDTH])) ? getBandwidthLimit('interval') : XMOOV_BW_PACKET_INTERVAL;
    $packet_size = ((XMOOV_CONF_ALLOW_DYNAMIC_BANDWIDTH && isset($_GET[XMOOV_GET_BANDWIDTH])) ? getBandwidthLimit('size') : XMOOV_BW_PACKET_SIZE) * 1042;
        
    if (!file_exists($file)) {
        print('<b>ERROR:</b> xmoov-php could not find (' . $fileName . ') please check your settings.'); 
        exit();
    }
    if(file_exists($file) && strrchr($fileName, '.') == '.flv' && strlen($fileName) > 2 && !eregi(basename($_SERVER['PHP_SELF']), $fileName) && ereg('^[^./][^/]*$', $fileName)) {
        $fh = fopen($file, 'rb') or die ('<b>ERROR:</b> xmoov-php could not open (' . $fileName . ')');                
        $fileSize = filesize($file) - (($seekPos > 0) ? $seekPos  + 1 : 0);
        if(!XMOOV_CONF_ALLOW_FILE_CACHE) {
            session_cache_limiter("nocache");
            header("Expires: Thu, 19 Nov 1981 08:52:00 GMT");
            header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
            header("Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0");
            header("Pragma: no-cache");
        }
            
        header("Content-Type: video/x-flv");
        header("Content-Disposition: attachment; filename=\"" . $fileName . "\"");
        header("Content-Length: " . $fileSize);
            
        if($seekPos != 0) {
            print('FLV');
            print(pack('C', 1));
            print(pack('C', 1));
            print(pack('N', 9));
            print(pack('N', 9));
        }
            
        fseek($fh, $seekPos);
            
        while(!feof($fh)) {
            if(XMOOV_CONF_LIMIT_BANDWIDTH && $packet_interval > 0) {
                list($usec, $sec) = explode(' ', microtime());
                $time_start = ((float)$usec + (float)$sec);
                print(fread($fh, $packet_size));
                list($usec, $sec) = explode(' ', microtime());
                $time_stop = ((float)$usec + (float)$sec);
                $time_difference = $time_stop - $time_start;
                if($time_difference < (float)$packet_interval) {
                    usleep((float)$packet_interval * 1000000 - (float)$time_difference * 1000000);
                }
            } else {
                print(fread($fh, filesize($file))); 
            }
        }            
    }        
}
?> 
